(*| 14:38 28/02/1992 *)
PROGRAM LISTUSES;

USES
  Printer;

TYPE
  LineString= STRING[80];
  MaxLine=String[255];

VAR
  OptionString,TextLine: LineString;
  SrcFileName,ListFileName: LineString;
  ThisFile,List: Text;
  Sline:MaxLine;
  ULines:Array[1..10] OF MaxLine;
  I,UIndex,P1,P2,P3,P4:Integer;
  FoundUses,ReadingInc: Boolean;
  Print,SaveToFile: Boolean;

FUNCTION UpperCase(S : LineString) : LineString;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : ',
          'LISTPROC [D:][SrcFileName] [DestFileName] [/P][/D]');
  Writeln('Switches : /P    Copy output to printer');
  Writeln('           /D    Copy output to disk, default filename *.USE');
  HALT;
END;  { ShowHelp }

PROCEDURE ProcessOptions;
BEGIN
  Print:=False;
  IF POS('/P',OptionString) > 0 THEN Print:=True;
  IF POS('/D',OptionString) > 0 THEN SaveToFile:=True;
END; { ProcessOptions }

PROCEDURE AddULines(ReadingInc:Boolean);

BEGIN
  IF NOT ReadingInc THEN BEGIN
    Inc(UIndex);
    IF UIndex = 1 THEN
      ULines[1]:=Copy(SLine,5,Length(SLine)-4)
    ELSE
      Ulines[UIndex]:=Sline;
    WHILE ULines[UIndex,1]=' ' DO
      DELETE(ULines[UIndex],1,1);
  END;
END;  {AddULines}

PROCEDURE WriteSLine;
BEGIN
  Writeln(Sline);
  IF SaveToFile THEN
    Writeln(List,Sline);
  IF Print THEN
    Writeln(LST,Sline);
END;  { WriteSLine }

PROCEDURE WriteBlankLine;
VAR
  OldSline: MaxLine;
BEGIN
  OldSline:=Sline;
  Sline:='';
  WriteSline;
  Sline:=OldSline;
END;  { WriteBlankLine }

PROCEDURE ShowUses(ReadingInc:Boolean);

VAR
  I,P1: Integer;
  Sline2:string[255];

BEGIN
  IF LENGTH(SLine) > 0 THEN IF SLine[1] <> ' ' THEN BEGIN
    SLine2:=Sline;
    FOR I:=1 TO LENGTH(SLine2) DO SLine2[I]:=UpCase(SLine2[I]);
    P1:=POS('USES',SLine2);
    IF (P1=1) THEN BEGIN
      FoundUses:=True;
      WriteSLine;
      AddULines(ReadingInc);
      WHILE POS(';',Sline) = 0 DO BEGIN
        Readln(ThisFile,Sline);
        WriteSLine;
        AddULines(ReadingInc);
      END;
    END;
  END;
END;  {ShowUses}

PROCEDURE ScanInclude(ReadingInc:Boolean);

BEGIN
  IF Pos('.',SrcFileName)=0 THEN SrcFileName:=SrcFileName+'.pas';
  ASSIGN(ThisFile,SrcFileName);
  {$I-}
  Reset(ThisFile);
  {$I+}
  IF IOResult <> 0 THEN BEGIN
    Writeln('Include File Error. File : ',SrcFileName);
    Writeln('Line : ',SLine);
    Halt;
  END;
  WriteBlankLine;
  Sline := 'File ' + SrcFileName;
  WriteSline;
  WriteBlankLine;
  FoundUses:=False;
{$IFDEF ONE_USE}
  WHILE NOT (EOF(ThisFile) OR FoundUses) DO BEGIN
{$ELSE}
  WHILE NOT EOF(ThisFile) DO BEGIN
{$ENDIF}
    Readln(ThisFile,Sline);
    ShowUses(ReadingInc);
  END;
  Close(ThisFile);
END;  {ScanInclude}

PROCEDURE GetFileNames(ThisLine:MaxLine);

VAR
  P:Integer;

BEGIN
  REPEAT
    P:=POS(',',ThisLine);
    IF P = 0 THEN P:=POS(';',ThisLine);
    IF P = 0 THEN
      ThisLine:=''
    ELSE BEGIN
      SrcFileName:=Copy(ThisLine,1,P-1);
      DELETE(ThisLine,1,P);
      FOR P:=1 TO LENGTH(SrcFileName) DO
        SrcFileName[P]:=UpCase(SrcFileName[P]);
      IF SrcFileName <> 'CRT' THEN
       IF SrcFileName <> 'DOS' THEN
        IF SrcFileName <> 'PRINTER' THEN
         IF SrcFileName <> 'STDTYPES' THEN
          IF SrcFileName <> 'DATE' THEN
           IF SrcFileName <> 'PACK2' THEN
            ScanInclude(True);
    END;
  UNTIL LENGTH(Thisline) = 0;
END;  {GetFileNames}

BEGIN
  ReadingInc:=False;
  UIndex:=0;
  OptionString:='';
  SaveToFile:=False;
  ListFileName:='';
  IF ParamCount = 0 THEN BEGIN
    Write('Source File Name:');
    Readln(SrcFileName);
  END ELSE FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN
        SrcFileName:=TextLine;
      IF I = 2 THEN BEGIN
        ListFileName:=TextLine;
        SaveToFile:=True;
      END;
    END;
  END;
  IF SrcFileName = '?' THEN
    ShowHelp;
  IF Pos('.',SrcFileName)=0 THEN SrcFileName:=SrcFileName+'.pas';
  ProcessOptions;
  IF SaveToFile THEN BEGIN
    IF Length(ListFileName) = 0 THEN
      ListFileName:=COPY(SrcFileName,1,POS('.',SrcFileName)) + 'USE';
    Assign(List,ListFileName);
    Rewrite(List);
  END;
  ScanInclude(False);
  IF UIndex > 0 THEN
    BEGIN
(*      FOR I:=1 TO UIndex DO Writeln(ULInes[I]);*)
      FOR I:=1 TO UIndex DO GetFileNames(ULines[I]);
    END;
  IF SaveToFile THEN
    Close(List);
END.
